/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	GameTimer
**
** DESCRIPTION:	Game timer
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef GAMETIMER_H
#define GAMETIMER_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CGameTimer
{
	friend class CGameTime;

private:

	//class data
	unsigned int	m_uiTime;

	//class methods
	//setup
	public:		CGameTimer(void);
	public:		void Reset(const unsigned int uiTime = 0);

	// process
	protected:	void Adjust(const int iOffset, const float fMultiplier);

	// access
	public:		void Set(const unsigned int uiSecondsFromNow);
	public:		const unsigned int Get() const;
	public:		const unsigned int SecondsRemaining() const;
	public:		void Increment(const unsigned int uiSeconds);
	public:		void Pause();
	public:		const bool IsActive() const;
	public:		const bool HasExpired() const;
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/